﻿using UnityEngine;
using System.Collections;
using UnityEditor;

public class TextureCounter : EditorWindow {

	private string stringValue;

	private int intValue;

	private float floatValue;

	private Vector2 vector2DValue;

	private Vector3 vector3DValue;

	private float minFloatValue;
	private float maxFloatValue;

	private int selectedSizeIndex = 0;

	private enum DamageType {
		Fire,
		Frost,
		Electric,
		Shadow
	}

	private DamageType damageType;

	private Vector2 scrollPosition;

	[MenuItem("Window/Licznik tekstur")]
	public static void Init() {
		var window = EditorWindow.GetWindow<TextureCounter>("Licznik tekstur");
		// Zapobiega usuwaniu okna w przypadku wczytywania nowej sceny
		DontDestroyOnLoad(window);
	}

	private void OnGUI() {
		int mode = 1;

		if (1 == mode) {
			using (var vertical = new EditorGUILayout.VerticalScope ()) {
				// Pobieramy listę wszystkich tekstur
				var paths = AssetDatabase.FindAssets ("t:texture");

				// Odczytujemy ich liczbę
				var count = paths.Length;

				// Wyświetlamy liczbę tekstur na etykiecie
				EditorGUILayout.LabelField ("Liczba tekstur: ", count.ToString ());
			}
		}

		if (2 == mode) {
			// Tu będzie umieszczony interfejs użytkownika edytora

			/*
		GUI.Label(                    // <1>
			new Rect(50,50,100,20),   // <2>
			"To jest etykieta!"       // <3>
		);
		//*/

			/*
		using (var verticalArea
			= new EditorGUILayout.VerticalScope()) {
		  		GUILayout.Label("Te etykiety");
				GUILayout.Label("zostaną wyświetlone");
				GUILayout.Label("w kolumnie");
				GUILayout.Label("jedna nad drugą.");
		}
		*/


			using (var verticalArea = new EditorGUILayout.VerticalScope ()) {
				var buttonClicked = GUILayout.Button ("Kliknij mnie!");
				if (buttonClicked) {
					Debug.Log ("Kliknięto przycisk w oknie edytora!");
				}


				this.stringValue = EditorGUILayout.TextField (this.stringValue);

				this.stringValue = EditorGUILayout.TextArea (
					this.stringValue, 
					GUILayout.Height (80)
				);

				this.intValue = 
				EditorGUILayout.IntField ("Wartość Int", this.intValue);

				this.floatValue = 
				EditorGUILayout.FloatField ("Wartość Float", this.floatValue);

				this.vector2DValue = 
				EditorGUILayout.Vector2Field ("Wartość Vector 2D", this.vector2DValue);

				this.vector3DValue = 
				EditorGUILayout.Vector3Field ("Wartość Vector 3D", this.vector3DValue);

				var minIntValue = 0;
				var maxIntValue = 10;
				this.intValue = EditorGUILayout.IntSlider (this.intValue, minIntValue, maxIntValue);

				var minLimit = 0;
				var maxLimit = 10;
				EditorGUILayout.MinMaxSlider (
					ref minFloatValue, ref maxFloatValue, minLimit, maxLimit);

				EditorGUILayout.Space ();

				var sizes = new string[] { "mały", "średni", "duży" };
				selectedSizeIndex = EditorGUILayout.Popup (selectedSizeIndex, sizes);


				damageType = (DamageType)EditorGUILayout.EnumPopup (damageType);


				using (var scrollView = new EditorGUILayout.ScrollViewScope (this.scrollPosition)) {

					this.scrollPosition = scrollView.scrollPosition;

					GUILayout.Label ("Te etykiety");
					GUILayout.Label ("zostaną wyświetlone");
					GUILayout.Label ("w kolumnie");
					GUILayout.Label ("jedna nad drugą.");
				}

			}



		}

	}

}
